/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   FreeStore Framework API Header File
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file FreeStore.h
 \brief Dynamic memory allocation API

 See \ref freestoregranularity, \ref freestorediagnostics and \ref freestorereliability
*/

#ifndef __FREESTORE_H
#define __FREESTORE_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/
#define FREE_STORE_GRANULARITY 16

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/

/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
void* ThreadSafeMalloc(NativeVar_U in_uNumBytes);
void ThreadSafeFree(void* in_pMemoryToFree);
uint4 QueryFreeStoreAllocationSize(void const* in_FreeStoreAddr);

#endif /* __FREESTORE_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
